//------------------------------------------------------------
//  Sample file: Part of ZModeler SDK
//
//  Purpose: Displays "Hello world" message box.
//------------------------------------------------------------
#include <struct.h>


DWORD CALLBACK Capabilities(long)
{
  return ZMODELER_BUILD_VERSION();
}


DWORD CALLBACK Supports(long)
{
  return Z3D_PLUGSUPPORTS_PROCESSING;
}

DWORD CALLBACK DynamicLoading(long)
{
  return 0; // DLL will be loaded ones.
}

DWORD CALLBACK GetProcsAmount(long)
{
  return 2;
}

DWORD CALLBACK PlaceType(long num)
{
  if (num == 0)
    return Z3D_PROCPLACE_MENUBAR;
  else
    return Z3D_PROCPLACE_MAINMENU;
}

char* CALLBACK GetProcName(long num)
{
  if (num == 0)
    return "Hello World";
  else
    return "Say Hello!";
}

char* CALLBACK GetMenuFolder(long num)
{
  if (num == 0)
    return "Tutorials...\0";
  else
    return "Tutorials\0";
}


char* CALLBACK GetProcComment(long num)
{
  return "Click the button to display message box";
}


//------------------------------------------------------------------
// the tool goes here.

//------------------------------------------------------------------
// Usually, each tool is implemented in separate CPP file, but for
// the sake of brivety, in this tutorial, all the functions and tools
// are implemented in one file.
DWORD CALLBACK HelloWorldPreMode(tProcParams* params)
{
  AfxMessageBox(
    "Hello World!\r\n...tool is selected");
  return 0;
}

DWORD CALLBACK HelloWorldOnLButtonDown(tProcParams* params)
{
  AfxMessageBox(
    "Hello to those who have just "
    "clicked with the left mouse button");
  return 0;
}

DWORD CALLBACK HelloWorldOnRButtonDown(tProcParams* params)
{
  AfxMessageBox(
    "Hello to those who have just "
    "clicked with the right mouse button");
  return 0;
}

DWORD CALLBACK HelloWorldOnHelp(tProcParams* params)
{
  AfxGetMainWnd()->MessageBox(
    "This tool displays \"Hello World!\" "
    "message box and interacts with mouse"
    " left and right buttons",
    "Hello World help:",
    MB_ICONQUESTION);
  return 0;
}

//-----------------------------------
// Say Hello tool:
DWORD CALLBACK SayHelloActivate(tProcParams* params)
{
  AfxMessageBox("Say Hello!");
  return 0;
}